library ieee;
use ieee.std_logic_1164.all;

Entity m is 
  port(xm,ym: in bit_vector(7 downto 0); clock,reset: in bit;
       zm: out bit_vector(7 downto 0)  );
End Entity;

Architecture m_arc of m is

Component c_adder8 is 
   port(x8,y8: IN bit_vector(7 downto 0); 
        s8: OUT bit_vector(7 downto 0);
        r8out: OUT bit;
        r8in: IN bit
        );
End Component;

for all: c_adder8 use entity work.adder8(adder8_arc);

signal timeshift: bit_vector(2 downto 0):="100";
signal x_campn,x_camp,diff8,adderin: bit_vector(7 downto 0):=X"00";
signal tmprout1,tmprout2: bit;
Begin
timeshift<= "100" when reset='1' and reset'event else
	        timeshift(0)&timeshift(3 downto 1) when reset='0' and clock='1' and clock'event else
	        timeshift;
 
x_camp<=X"00" when reset='1' and reset'event else
        xm when timeshift(0)='1' and timeshift(0)'event else
        x_camp;
x_campn<= not x_camp;        
        
        

adderin<="0000"&diff8(3 downto 0);
subtractor: c_adder8 port map(ym,x_campn,diff8,tmprout1,'1');

adderx: c_adder8 port map(x_camp,adderin,zm,tmprout2,'0');
        

End;

