library ieee;
use ieee.std_logic_1164.all;

Entity adder8 is 

   port(x8,y8: IN bit_vector(7 downto 0); 
        s8: OUT bit_vector(7 downto 0);
        r8out: OUT bit;
        r8in: IN bit
        );
End entity;


Architecture adder8_arc of adder8 is
Component fa is 

 port(x,y,rin: IN BIT; z,rout: OUT BIT);
End Component fa;

for all: fa use Entity work.fa(fa_arc);

signal temp: bit_vector(7 downto 0):=X"00";

Begin

fa1 : fa port map(x8(0),y8(0),r8in, s8(0),temp(0));
lable_gen:
   for ii in 1 to 7 generate
      fax: fa port map(x8(ii),y8(ii),temp(ii-1), s8(ii),temp(ii));
   end generate;


r8out<=temp(7);



End Architecture;

