library ieee;
use ieee.std_logic_1164.all, ieee.numeric_std.all;

Entity somm8 is
port(x8,y8: IN bit_vector(7 downto 0); 
        s8: OUT bit_vector(7 downto 0);
        r8out: OUT bit;
        r8in: IN bit
        );
End entity;

Architecture somm8_arc of somm8 is

Begin

--sommatore con accumulatore(effettua la somma solo quando viene campionato un nuovo valore)
p:process(x8,y8,r8in)
	
	variable a,b,s:integer;
	
	Begin
	
	a:=to_integer(unsigned(to_stdlogicvector(x8)));
	b:=to_integer(unsigned(to_stdlogicvector(y8)));
	s:=a+b;
	if (r8in='1') 
	 then
	  s:=s+1;
	end if;
	if (s>255) 
	  then
	   s:=0; 
	   r8out<='1';
	end if;
	
	--z<=to_bitvector(std_logic_vector(to_unsigned(s,8)));
	s8<=to_bitvector(std_logic_vector(to_unsigned(s,8)));
	End process;

End;
