library ieee;
use ieee.std_logic_1164.all;

entity tb is
end entity;

architecture arc of tb is

signal init, clk, sync, rst : std_logic := '0';
signal result : std_logic_vector(8 downto 0) := "000000000";
signal char : std_logic_vector(75 downto 0) := "0101010100101010101010101110010101001010101010100101010100101010100101010101";
signal index : integer := 0;
signal sel : std_logic_vector(1 downto 0) := "00";

begin
	
	clk <= not clk after 5 us;
	
	index <= index + 1 when clk='1' and clk'event;
	
	init <= char(index);
	
	sel <= "01" after 180 us, "10" after 320 us, "11" after 380 us, "00" after 630 us;
	
	--rst <= '1' after 300 us, '0' after 350 us;
	
	m : entity work.macchina port map (clk, rst, init, init, sel, sync, result);
	
end architecture;