library ieee;
use ieee.std_logic_1164.all;

entity macchina is
	port (
		clk, rst, x, y : in std_logic;
		sel : in std_logic_vector(1 downto 0);
		sync : out std_logic;
		result : out std_logic_vector(8 downto 0)
	);
end entity;

architecture arc of macchina is

signal char : std_logic_vector(8 downto 0) := "101010101";
signal tempx, tempy, campx, campy : std_logic_vector(8 downto 0) := "000000000";
signal tempsync, ricx, ricy : std_logic := '0';
signal paritax, paritay, enb, rin, rout : std_logic := '0';
signal enable : std_logic_vector(8 downto 0) := "100000000";
signal tempin, tempout : std_logic_vector(7 downto 0) := "00000000";

begin

	-- segnale che abilita le operazioni ogni 9 colpi di clock
	enable <= "100000000" when rst='1' or (tempsync='0' and tempsync'event) else
			  enable(0) & enable(8 downto 1) when tempsync='1' and  clk='1' and clk'event;
			  
	enb <= enable(0), '0' after 1 us;
	
	-- tutti i registri interni vengono messi a zero quando reset è pari a 1
	-- oppure sul fronte di discesa del segnale tempsync
	
	tempx <= "000000000" when rst='1' or (tempsync='0' and tempsync'event) else
			 x & tempx(8 downto 1) when clk='1' and clk'event;
			 
	tempy <= "000000000" when rst='1' or (tempsync='0' and tempsync'event) else
			 y & tempy(8 downto 1) when clk='1' and clk'event;
			 
	-- segnale che riconosce se è stato ricevuto il carattere di sincronizzazione
	ricx <= (tempx(0) xnor char(0)) and (tempx(1) xnor char(1)) and (tempx(2) xnor char(2)) and
			(tempx(3) xnor char(3)) and (tempx(4) xnor char(4)) and (tempx(5) xnor char(5)) and
			(tempx(6) xnor char(6)) and (tempx(7) xnor char(7)) and (tempx(8) xnor char(8))
			when tempsync='0';
			
	ricy <= (tempy(0) xnor char(0)) and (tempy(1) xnor char(1)) and (tempy(2) xnor char(2)) and
			(tempy(3) xnor char(3)) and (tempy(4) xnor char(4)) and (tempy(5) xnor char(5)) and
			(tempy(6) xnor char(6)) and (tempy(7) xnor char(7)) and (tempy(8) xnor char(8))
			when tempsync='0';
	
	tempsync <= '0' when rst='1' or (paritax='1') or (paritay='1') else ricx and ricy;
	
	sync <= tempsync;
	
	-- calcola della parità
	paritax <= '0' when rst='1' or (tempsync='0' and tempsync'event) else 
				(tempx(0) xor tempx(1) xor tempx(2) xor tempx(3) xor tempx(4) xor tempx(5)
				 xor tempx(6) xor tempx(7) xor tempx(8)) when enb='1' and enb'event;
	
	paritay <= '0' when rst='1' or (tempsync='0' and tempsync'event) else 
				(tempy(0) xor tempy(1) xor tempy(2) xor tempy(3) xor tempy(4) xor tempy(5)
				 xor tempy(6) xor tempy(7) xor tempy(8)) when enb='1' and enb'event;
	
	-- campionamento di tempx e tempy sul segnale di enable
	campx <= "000000000" when rst='1' or (tempsync='0' and tempsync'event) else 
			 tempx when tempsync='1' and enb='1' and enb'event;
	
	campy <= "000000000" when rst='1' or (tempsync='0' and tempsync'event) else 
			 tempy when tempsync='1' and enb='1' and enb'event;
				
	-- condizionamento dei segnali in ingresso all'adder in base al segnale sel
	tempin <= campy(7 downto 0) when sel="00" else
			  not campy(7 downto 0) when sel="01" else
			  x"00";
			  
	rin <= '1' when sel="01" else '0';
	
	adder : entity work.adder8 port map(campx(7 downto 0), tempin, rin, tempout, rout);
	
	result <= "000000000" when rst='1' or (tempsync='0' and tempsync'event) else
			  not rout & tempout when (sel="00" or sel="01") and tempsync='1' and enb='0' and enb'event else
			  '0' & (campx(7 downto 0) xor campy(7 downto 0)) when sel="10" and tempsync='1' and enb='0' and enb'event else
			  '0' & (campx(7 downto 0) and campy(7 downto 0)) when sel="11" and tempsync='1' and enb='0' and enb'event;
	
end architecture;
