library ieee;
use ieee.std_logic_1164.all;

entity adder8 is
	port (
		x, y : in std_logic_vector(7 downto 0);
		rin : in std_logic;
		s : out std_logic_vector(7 downto 0);
		rout : out std_logic
	);
end entity adder8;

architecture RTL of adder8 is
	
component fa is
	port (
		x : in std_logic;
		y : in std_logic;
		rin : in std_logic;
		s, rout : out std_logic
	);
end component fa;

signal temp : std_logic_vector(8 downto 0) := "000000000";
	
begin
	
	temp(0) <= rin;
	
	GEN_ST:
	for i in 0 to 7 generate
		full_adder : fa port map (
			x(i), y(i), temp(i), s(i), temp(i + 1)
		);
	end generate GEN_ST;
	
	rout <= temp(8);

end architecture RTL;