library ieee;
use ieee.numeric_bit.all;


Entity Divisore is 
port (
      x,y: in bit_vector(7 downto 0);
      clock, reset: in bit;
      qf,resto: out bit_vector(7 downto 0)
      );
End Entity;
	 
Architecture div_arch of divisore is
signal sh16: bit_vector(15 downto 0);
signal q: bit:='0';
signal subout, subin, compout: bit_vector(7 downto 0);
signal p: bit;

Component Compare is
port (a,b: in bit_vector(7 downto 0);
      q: out bit;
      sub: out bit_vector(7 downto 0));
End Component;

 Component adder is 
 port (x8,y8: in bit_vector(7 downto 0); r8in: in bit;
       s8: out bit_vector(7 downto 0); r8out: out bit);
 End Component;


for all : compare use Entity work.comparator(comp_arch);
for all : adder use Entity work.adder8(adder8_arc);

Begin 
 
 sh16<= "00000000"&x when reset='1' and reset'event else
        sh16(14 downto 0)&q when reset='1' and clock='1' and clock'event else
        subout&sh16(7 downto 1)&q when reset='1' and clock='0' and clock'event else
        sh16;

subin<=not compout;
 
c: compare port map(sh16(15 downto 8), y,q,compout);

s: adder   port map(sh16(15 downto 8), subin, '1',subout,p);

resto<=sh16(15 downto 8);
qf<=sh16(7 downto 0);


End;
