library ieee;
use ieee.std_logic_1164.all, ieee.numeric_std.all;

Architecture macchina_struct of macchina is

Component cont is 
  port (ck, reset: in bit; 
        ripple: out bit );
End Component;

Component dec is 
  port (rd, dstrobe: in bit; 
        dp, dcipher: in bit_vector(7 downto 0);
        dplain: out bit_vector(7 downto 0));
 End Component;

Component cod is 
  port (rc, cstrobe: in bit; 
        cp, cplain: in bit_vector(7 downto 0);
        ccipher: out bit_vector(7 downto 0));
 End Component;


For all: dec use Entity work.decodificatore(decodificatore_arc);
For all: cod use Entity work.codificatore(codificatore_arc);

For all: cont use Entity work.contatore(contatore_arc);

signal sh1: bit_vector(7 downto 0);
signal sh2: bit_vector(7 downto 0);
signal tamp1: bit_vector(7 downto 0):="00000000";
signal tamp2, tamp3: bit_vector(7 downto 0):="00000000";
signal rip, rip_a: bit;
signal sel: bit_vector(2 downto 0);

Begin

sh1<= x&sh1(7 downto 1) when ckm'event and ckm='1' else
      sh1;

tamp1<=sh1 when rip='1' and rip'event else
	   tamp1;
	   
cont1: cont port map(ckm,r,rip);

rip_a<=rip after 1 ms;
cod1:  cod port map(r,rip_a,p,tamp1,tamp2);
dec1:  dec port map(r,rip_a,p,tamp1,tamp3);

sh2<=tamp3 when rip'event and rip='0' and c='0' else
     tamp2 when rip'event and rip='0' and c='1' else
     '0'&sh2(7 downto 1) when ckm'event and ckm='1' else
     sh2;
y<=sh2(0);
     
End;
