library ieee;
use ieee.std_logic_1164.all, ieee.numeric_std.all;

Entity macchina is 
  port (r, x,ckm,c: in bit; 
        p: in bit_vector(7 downto 0);
        y: out bit);
 End Entity;

Architecture macchina_arc of macchina is

Component cont is 
  port (ck, reset: in bit; 
        ripple: out bit );
End Component;




For all: cont use Entity work.contatore(contatore_arc);

signal sh1: bit_vector(7 downto 0);
signal sh2: bit_vector(7 downto 0);
signal tamp1: bit_vector(7 downto 0):="00000000";
signal tamp2, tamp3: bit_vector(7 downto 0):="00000000";
signal oldtamp3: bit_vector(7 downto 0):="00000000";
signal rip: bit;
signal sel: bit_vector(2 downto 0);

Begin

sh1<= x&sh1(7 downto 1) when ckm'event and ckm='1' else
      sh1;

tamp1<=sh1 when rip='1' and rip'event else
	   tamp1;
sel<=c&p(1 downto 0);	
	   
with  sel select
 tamp2<= 
        tamp1(0)&tamp1(7 downto 1) 			when "000",
        tamp1(1 downto 0)&tamp1(7 downto 2) when "001",
        tamp1(2 downto 0)&tamp1(7 downto 3) when "010",
        tamp1(3 downto 0)&tamp1(7 downto 4) when "011",
	    tamp1(6 downto 0)&tamp1(7)			when "100",
        tamp1(5 downto 0)&tamp1(7 downto 6) when "101",
        tamp1(4 downto 0)&tamp1(7 downto 5) when "110",
        tamp1(3 downto 0)&tamp1(7 downto 4) when "111";

cont1: cont port map(ckm,r,rip);

tamp3<=tamp2 xor p xor oldtamp3;

oldtamp3<="00000000" when r='1' else
		  tamp3 when rip'event and rip='0' and c='0' else
		  tamp1 when rip'event and rip='0' and c='1' else
		  oldtamp3;

sh2<=tamp3 when rip'event and rip='0' else
     '0'&sh2(7 downto 1) when ckm'event and ckm='1' else
     sh2;
y<=sh2(0);
     
End;
