library ieee;
use ieee.std_logic_1164.all, ieee.numeric_std.all;

Entity decodificatore is 
  port (rd, dstrobe: in bit; 
        dp, dcipher: in bit_vector(7 downto 0);
        dplain: out bit_vector(7 downto 0));
 End Entity;

Architecture decodificatore_arc of decodificatore is


signal tamp1: bit_vector(7 downto 0):="00000000";
signal tamp2, tamp3: bit_vector(7 downto 0):="00000000";
signal oldtamp3: bit_vector(7 downto 0):="00000000";


Begin

tamp1<=dcipher when dstrobe'event and dstrobe='1' else
	   tamp1;
	   
with  dp(1 downto 0) select
 tamp2<= 
	    tamp1(6 downto 0)&tamp1(7)			when "00",
        tamp1(5 downto 0)&tamp1(7 downto 6) when "01",
        tamp1(4 downto 0)&tamp1(7 downto 5) when "10",
        tamp1(3 downto 0)&tamp1(7 downto 4) when "11";
        
tamp3<=tamp2 xor dp xor oldtamp3;

oldtamp3<="00000000" when rd='1' else
		  tamp1 when dstrobe'event and dstrobe='0' else
		  oldtamp3;

dplain<=oldtamp3;
     
End;
