library ieee;
use ieee.std_logic_1164.all, ieee.numeric_std.all;

Entity codificatore is 
  port (rc, cstrobe: in bit; 
        cp, cplain: in bit_vector(7 downto 0);
        ccipher: out bit_vector(7 downto 0));
 End Entity;

Architecture codificatore_arc of codificatore is


signal tamp1: bit_vector(7 downto 0):="00000000";
signal tamp2, tamp3: bit_vector(7 downto 0):="00000000";
signal oldtamp3: bit_vector(7 downto 0):="00000000";
signal rip: bit;
signal sel: bit_vector(2 downto 0);

Begin

tamp1<=cplain when cstrobe'event and cstrobe='1' else
	   tamp1;
	   
with  cp(1 downto 0) select
 tamp2<= 
        tamp1(0)&tamp1(7 downto 1) 			when "00",
        tamp1(1 downto 0)&tamp1(7 downto 2) when "01",
        tamp1(2 downto 0)&tamp1(7 downto 3) when "10",
        tamp1(3 downto 0)&tamp1(7 downto 4) when "11";


tamp3<=tamp2 xor cp xor oldtamp3;

oldtamp3<="00000000" when rc='1' else
		  tamp3 when cstrobe'event and cstrobe='0' else
		  oldtamp3;

ccipher<=oldtamp3;
     
End;
