#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/interrupt.h>
#include <linux/jiffies.h>
#include <linux/init.h>

MODULE_LICENSE("GPL");

int irq;
module_param(irq, int, 0);

/* this is used as devid in the handler */
struct tirq_data {
	unsigned long seconds;
	unsigned long count;
} data;

/* the handler */
static int tirq_handler(int irq, void *devid, struct pt_regs *regs)
{
	struct tirq_data *d = (struct tirq_data *)devid;
	unsigned long seconds = jiffies/HZ;

	d->count++;
	if (seconds != d->seconds) {
		/* next second: print stats */
		printk(KERN_INFO "tirq: irq %i: got %li events\n",
		       irq, d->count);
		d->count = 0;
		d->seconds = seconds;
	}
	return IRQ_NONE;
}

/* load time */
static int tirq_init(void)
{
	int err;

	err = request_irq(irq, tirq_handler, SA_SHIRQ, "tirq", &data);
	if (err) return err;
	return 0;
}

/* unload time */
static void tirq_exit(void)
{
	free_irq(irq, &data);
}

module_init(tirq_init);
module_exit(tirq_exit);



MAkefile

ifndef KERNELRELEASE

   LINUX ?= /usr/src/linux
   PWD := $(shell pwd)
all:
	$(MAKE) -C $(LINUX) SUBDIRS=$(PWD) modules
clean:
	rm -f *.o *.ko *~ core .depend *.mod.c *.cmd

else
   obj-m := tirq.o
endif

sudo insmod src/tirq.ko irq=10
